//Listing 17.6. Przykad specjalizacji klasy szablonu
#include <iostream>
using namespace std;

template <class T>
class Array {
  T *data; // tablica danych przydzielona na stercie
  int size; // rozmiar tablicy 
  Array(const Array&);
  operator = (const Array&);
public:
  Array(T items[], int n) : size(n) // konstruktor konwertujcy
  { data = new T[n]; // przydziela pami na stercie
    if (data==0)
       { cout << "Brak pamici\n"; exit(1); }
    for (int i=0; i < n; i++)
       data[i] = items[i]; }
  int find (const T& val) const
  { for (int i = 0; i < size; i++)
       if (val == data[i])
           return i;
    return -1; }
  ~Array()
  { delete [] data; }
} ;

template <> // pusta lista szablonu
class Array <char *> { // typ specjalizacji
  char* *data; // tablica z danymi na stercie
  int size; // rozmiar tablicy
  Array(const Array&);
  operator = (const Array&);
public:
  Array(char* items[], int n) : size(n) // konwersja
  { data = new char*[n]; // przydziela pami na stercie
    if (data==0)
        { cout << "Brak pamici\n"; exit(1); }
    for (int i=0; i < n; i++)
        { int len = strlen(items[i]); // jedynie dla acuchw znakowych
          data[i] = new char[len+1];
        strcpy(data[i],items[i]); } }
  int find (const char*& val) const
  { for (int i = 0; i < size; i++)
       if (strcmp(val,data[i])==0) // jedynie dla acuchw znakowych
             return i;
    return -1; }
  ~Array()
  { delete [] data; }
} ;

int main()
{
  int data1[] = { 1, 2, 3, 4, 5 } ;
  char* data2[] = { "raz", "dwa", "trzy", "cztery", "pi" } ;
  int n1 = sizeof(data1)/sizeof(int); // liczba komponentw
  int n2 = sizeof(data2)/sizeof(char*);
  cout << "Dane pocztkowe: ";
  for (int j = 0; j < n1; j++)
  { cout << data1[j] << " "; } // wypisuje dane wejciowe
  cout << endl;
  for (int i = 0; i < n2; i++)
  { cout << data2[i] << " "; } // wypisuje dane wejciowe
  cout << endl;
  Array<int> a1(data1,n1); // obiekt tablicy
  Array<char*> a2(data2,n2); // obiekt specjalizowany
  int item1 = 3; int idx;
  char* item2 = "three";
  if ((idx = a1.find(item1)) != -1)
      cout << "Element " << item1 <<" ma indeks " << idx << endl;
  if ((idx = a2.find(item2)) != -1)
      cout << "Element " << item2 <<" ma indeks " << idx << endl;
  return 0;
}
